<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Relatório - <?php echo e($order['id']); ?></title>
    <style>
        @page {
            margin: 1cm 1.2cm;
        }

        * {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 8.5pt;
            color: #000;
            line-height: 1.2;
        }

        .header {
            background-color: #1f2257;
            color: white;
            padding: 8px 12px;
            margin-bottom: 10px;
            text-align: center;
        }

        .header .logo {
            max-width: 150px;
            max-height: 50px;
            margin: 0 auto 6px auto;
            display: block;
        }

        .header h1 {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 2px;
        }

        .header .date {
            font-size: 7pt;
            color: rgba(255, 255, 255, 0.9);
        }

        .section {
            margin-bottom: 8px;
            padding-left: 4px;
        }

        .section-title {
            font-size: 10pt;
            font-weight: bold;
            color: #1f2257;
            margin-bottom: 4px;
            padding-bottom: 2px;
            border-bottom: 2px solid #1f2257;
        }

        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 4px;
            font-size: 8pt;
        }

        .info-table td {
            padding: 2px 6px 2px 10px;
            border-bottom: 1px solid #e5e5e5;
        }

        .info-table td:first-child {
            width: 32%;
            font-weight: bold;
            color: #333;
        }

        .info-table td:last-child {
            color: #555;
        }

        .info-table tr:last-child td {
            border-bottom: none;
        }

        .summary-box {
            background-color: #f8f9fa;
            padding: 6px 8px;
            border: 1px solid #dee2e6;
            border-left: 3px solid #1f2257;
            margin: 6px 0;
        }

        .summary-box .info-table {
            margin: 0;
        }

        .summary-box .info-table td {
            border: none;
            padding: 1px 0;
        }

        .validation-status {
            padding: 5px 8px;
            margin: 6px 0;
            font-weight: bold;
            text-align: center;
            font-size: 8.5pt;
            border: 2px solid;
        }

        .validation-success {
            background-color: #d4edda;
            color: #155724;
            border-color: #28a745;
        }

        .validation-error {
            background-color: #f8d7da;
            color: #721c24;
            border-color: #dc3545;
        }

        .comparison-table {
            width: 100%;
            border-collapse: collapse;
            margin: 6px 0;
            font-size: 7.5pt;
        }

        .comparison-table th {
            background-color: #1f2257;
            color: white;
            border: 1px solid #1f2257;
            padding: 3px 4px 3px 8px;
            text-align: left;
            font-weight: bold;
            font-size: 8pt;
        }

        .comparison-table td {
            border: 1px solid #ddd;
            padding: 3px 4px 3px 8px;
            vertical-align: middle;
        }

        .comparison-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .status-check {
            text-align: center;
            font-weight: bold;
            font-size: 10pt;
            width: 40px;
        }

        .status-success {
            color: #28a745;
        }

        .status-error {
            color: #dc3545;
        }

        .cassette-detail {
            margin: 3px 0;
            padding: 4px 6px 4px 10px;
            background-color: #f9f9f9;
            border-left: 3px solid #1f2257;
            border: 1px solid #e0e0e0;
            border-left: 3px solid #1f2257;
            font-size: 7.5pt;
        }

        .cassette-detail strong {
            color: #1f2257;
            display: inline;
            margin-right: 5px;
        }

        .inline-info {
            display: inline-block;
            margin-right: 15px;
        }

        .footer {
            text-align: center;
            font-size: 6.5pt;
            color: #888;
            padding: 5px 0;
            border-top: 1px solid #ddd;
            margin-top: 8px;
        }

        .subtitle {
            font-size: 9pt;
            font-weight: bold;
            color: #1f2257;
            margin: 6px 0 4px 0;
        }

        .compact-row {
            margin: 3px 0;
        }
    </style>
</head>
<body>
    <!-- Cabeçalho -->
    <div class="header">
        <img src="<?php echo e(base_path('public/GRS_Logo_Tipo.png')); ?>" alt="GRS Logo" class="logo" />
        <h1>RELATÓRIO DE CARREGAMENTO DE ATMs</h1>
        <div class="date">Gerado em: <?php echo e(now()->format('d/m/Y H:i:s')); ?></div>
    </div>

    <!-- Informações do Pedido -->
    <div class="section">
        <div class="section-title">INFORMAÇÕES DO PEDIDO</div>
        <table class="info-table">
            <tr>
                <td>ID</td>
                <td><?php echo e($order['id']); ?></td>
            </tr>
            <tr>
                <td>Banco</td>
                <td><?php echo e($order['bank']['name']); ?></td>
            </tr>
            <tr>
                <td>Estado</td>
                <td><?php echo e(ucfirst($order['status'])); ?></td>
            </tr>
            <?php if(isset($order['responsible'])): ?>
            <tr>
                <td>Responsável</td>
                <td><?php echo e($order['responsible']['name']); ?><?php if(isset($order['responsible']['phone'])): ?> - <?php echo e($order['responsible']['phone']); ?><?php endif; ?></td>
            </tr>
            <?php endif; ?>
            <tr>
                <td>Data Pedido</td>
                <td><?php echo e($order['date']); ?></td>
            </tr>
            <?php if(isset($order['completed_at'])): ?>
            <tr>
                <td>Data Conclusão</td>
                <td><?php echo e(\Carbon\Carbon::parse($order['completed_at'])->format('d/m/Y H:i')); ?></td>
            </tr>
            <?php endif; ?>
            <tr>
                <td>Tempo Carregamento</td>
                <td><?php echo e($order['loading_duration'] ?? $order['duration'] ?? '-'); ?></td>
            </tr>
            <tr>
                <td>Localização</td>
                <td><?php echo e($order['location']); ?></td>
            </tr>
            <tr>
                <td>Rota</td>
                <td><?php echo e($order['route']); ?></td>
            </tr>
            <tr>
                <td>Distância</td>
                <td><?php echo e($order['distance']); ?></td>
            </tr>
        </table>
    </div>

    <!-- Resumo de Carregamento -->
    <div class="section">
        <div class="section-title">RESUMO</div>
        <div class="summary-box">
            <table class="info-table">
                <tr>
                    <td>ATMs Abastecidos</td>
                    <td><?php echo e($order['atms_count']); ?></td>
                </tr>
                <tr>
                    <td>Cassetes Carregadas</td>
                    <td>
                        <?php echo e(isset($order['atms']) ? collect($order['atms'])->sum('cassettes_count') : 0); ?>

                    </td>
                </tr>
            </table>
        </div>
    </div>

    <!-- Validação e Comparação de Dados -->
    <div class="section">
        <div class="section-title">VALIDAÇÃO E COMPARAÇÃO</div>
        
        <?php
            $hasValidation = isset($order['atms']) && collect($order['atms'])->some(fn($atm) => isset($atm['validation']));
            $allValidated = true;
            $validatedCount = 0;
            $totalToValidate = 0;
            
            if ($hasValidation && isset($order['atms'])) {
                foreach ($order['atms'] as $atm) {
                    if (isset($atm['validation'])) {
                        $totalToValidate++;
                        if ($atm['validation']['validated'] ?? false) {
                            $validatedCount++;
                        } else {
                            $allValidated = false;
                        }
                    }
                }
            }
        ?>

        <?php if($hasValidation && isset($order['atms'])): ?>
            <?php if($allValidated && $validatedCount > 0): ?>
                <div class="validation-status validation-success">
                    ✓ DADOS CONFEREM
                </div>
            <?php elseif($validatedCount > 0): ?>
                <div class="validation-status validation-error">
                    ✗ DIVERGÊNCIAS ENCONTRADAS
                </div>
            <?php else: ?>
                <div class="validation-status" style="background-color: #fff3cd; color: #856404; border-color: #ffc107;">
                    VALIDAÇÃO PENDENTE
                </div>
            <?php endif; ?>

            <table class="info-table" style="margin: 4px 0;">
                <tr>
                    <td>Sistema Origem</td>
                    <td>Sistema de Gestão de ATMs</td>
                </tr>
                <?php if(isset($order['atms'][0]['validation']['validated_at'])): ?>
                <tr>
                    <td>Data Validação</td>
                    <td>
                        <?php echo e(\Carbon\Carbon::parse($order['atms'][0]['validation']['validated_at'])->format('d/m/Y H:i')); ?>

                    </td>
                </tr>
                <?php endif; ?>
            </table>

            <!-- Comparação por ATM -->
            <?php $__currentLoopData = $order['atms']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $atm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(isset($atm['validation'])): ?>
                    <div class="compact-row">
                        <div style="color: #1f2257; margin-bottom: 3px; font-size: 8.5pt; font-weight: bold; padding-left: 4px;">
                            ATM <?php echo e($index + 1); ?>: <?php echo e($atm['id']); ?>

                        </div>
                        
                        <table class="comparison-table">
                            <thead>
                                <tr>
                                    <th style="width: 18%;">Item</th>
                                    <th style="width: 32%;">Esperado</th>
                                    <th style="width: 32%;">Retornado</th>
                                    <th style="width: 18%;">Estado</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $idMatch = $atm['id'] === $atm['validation']['atm_id'];
                                    $statusMatch = $atm['status'] === $atm['validation']['status'];
                                    $cassettesMatch = $atm['cassettes_count'] === $atm['validation']['cassettes_count'];
                                    $dateMatch = ($atm['loading_date'] ?? null) === ($atm['validation']['loading_date'] ?? null);
                                ?>
                                <tr>
                                    <td><strong>ID</strong></td>
                                    <td><?php echo e($atm['id']); ?></td>
                                    <td><?php echo e($atm['validation']['atm_id']); ?></td>
                                    <td class="status-check <?php echo e($idMatch ? 'status-success' : 'status-error'); ?>">
                                        <?php echo e($idMatch ? '✓' : '✗'); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Estado</strong></td>
                                    <td><?php echo e($atm['status']); ?></td>
                                    <td><?php echo e($atm['validation']['status']); ?></td>
                                    <td class="status-check <?php echo e($statusMatch ? 'status-success' : 'status-error'); ?>">
                                        <?php echo e($statusMatch ? '✓' : '✗'); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Cassetes</strong></td>
                                    <td><?php echo e($atm['cassettes_count']); ?></td>
                                    <td><?php echo e($atm['validation']['cassettes_count']); ?></td>
                                    <td class="status-check <?php echo e($cassettesMatch ? 'status-success' : 'status-error'); ?>">
                                        <?php echo e($cassettesMatch ? '✓' : '✗'); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Data</strong></td>
                                    <td><?php echo e($atm['loading_date'] ?? 'N/A'); ?></td>
                                    <td><?php echo e($atm['validation']['loading_date'] ?? 'N/A'); ?></td>
                                    <td class="status-check <?php echo e($dateMatch ? 'status-success' : 'status-error'); ?>">
                                        <?php echo e($dateMatch ? '✓' : '✗'); ?>

                                    </td>
                                </tr>
                            </tbody>
                        </table>

                        <!-- Detalhamento de Cassetes (Compacto) -->
                        <?php if(isset($atm['cassettes']) && isset($atm['validation']['cassettes']) && count($atm['cassettes']) > 0): ?>
                            <div style="margin-top: 4px;">
                                <div style="color: #1f2257; font-size: 8pt; font-weight: bold; margin-bottom: 3px; padding-left: 4px;">
                                    Cassetes:
                                </div>
                                <?php $__currentLoopData = $atm['cassettes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cIndex => $cassette): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $validationCassette = $atm['validation']['cassettes'][$cIndex] ?? null;
                                        $notesMatch = $validationCassette && $cassette['notes'] === $validationCassette['notes'];
                                    ?>
                                    <div class="cassette-detail">
                                        <strong>C<?php echo e($cIndex + 1); ?>:</strong>
                                        <span class="inline-info">Esp: <?php echo e($cassette['notes']); ?></span>
                                        <?php if($validationCassette): ?>
                                            <span class="inline-info">Ret: <?php echo e($validationCassette['notes']); ?></span>
                                            <span style="font-weight: bold; color: <?php echo e($notesMatch ? '#28a745' : '#dc3545'); ?>;">
                                                <?php echo e($notesMatch ? '✓' : '✗'); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <!-- Resumo da Validação -->
            <div class="summary-box" style="margin-top: 6px;">
                <div style="font-size: 9pt; font-weight: bold; color: #1f2257; margin-bottom: 4px; padding-bottom: 2px; border-bottom: 2px solid #1f2257;">
                    RESUMO VALIDAÇÃO
                </div>
                <table class="info-table">
                    <tr>
                        <td>ATMs Validados</td>
                        <td><strong><?php echo e($totalToValidate); ?></strong></td>
                    </tr>
                    <tr>
                        <td>Conferindo</td>
                        <td><strong style="color: #28a745;"><?php echo e($validatedCount); ?></strong></td>
                    </tr>
                    <?php if($totalToValidate > $validatedCount): ?>
                    <tr>
                        <td>Divergências</td>
                        <td><strong style="color: #dc3545;"><?php echo e($totalToValidate - $validatedCount); ?></strong></td>
                    </tr>
                    <?php endif; ?>
                </table>
            </div>
        <?php else: ?>
            <div style="padding: 6px 6px 6px 10px; background-color: #fff3cd; border: 1px solid #ffc107; color: #856404; margin: 6px 0; font-size: 8pt;">
                Validação pendente - Aguardando dados do sistema externo
            </div>
        <?php endif; ?>
    </div>

    <!-- Detalhamento por ATM (Compacto) -->
    <div class="section">
        <div class="section-title">DETALHAMENTO ATMs</div>
        
        <?php if(isset($order['atms']) && count($order['atms']) > 0): ?>
            <?php $__currentLoopData = $order['atms']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $atm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div style="margin: 4px 0; padding: 6px 6px 6px 10px; border: 1px solid #ddd; border-left: 3px solid #1f2257; background-color: #fafafa; font-size: 8pt;">
                    <div style="color: #1f2257; font-weight: bold; margin-bottom: 3px;">
                        ATM <?php echo e($index + 1); ?>: <?php echo e($atm['id']); ?>

                    </div>
                    <div class="inline-info"><strong>Estado:</strong> <?php echo e($atm['status']); ?></div>
                    <div class="inline-info"><strong>Cassetes:</strong> <?php echo e($atm['cassettes_count']); ?></div>
                    <?php if(isset($atm['loading_date'])): ?>
                    <div class="inline-info"><strong>Data:</strong> <?php echo e($atm['loading_date']); ?></div>
                    <?php endif; ?>
                    <?php if(isset($atm['cassettes']) && count($atm['cassettes']) > 0): ?>
                        <div style="margin-top: 4px;">
                            <?php $__currentLoopData = $atm['cassettes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cIndex => $cassette): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span style="margin-right: 10px;"><?php echo e($cIndex + 1); ?>. <?php echo e($cassette['notes']); ?> (<?php echo e($cassette['status']); ?>)</span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </div>

    <div class="footer">
        Relatório gerado automaticamente pelo sistema
    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\carregamento\my-app\resources\views/reports/order-pdf.blade.php ENDPATH**/ ?>